<?php
$UPSTREAM_BASE = 'http://development-partners-reports.infra.oddsscanner.org';

// get query path (ex: /reports/SummaryReport)
$path = $_GET['path'] ?? '';
if ($path === '') {
    http_response_code(400);
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Missing path']);
    exit;
}

// build final URL
$target = rtrim($UPSTREAM_BASE, '/') . $path;

// POST body from the frontend
$rawBody = file_get_contents('php://input');

// prepare cURL
$ch = curl_init($target);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HEADER         => true,
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => $rawBody,
    CURLOPT_HTTPHEADER     => [
        'Content-Type: application/json',
        'Accept: application/json'
    ],
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_MAXREDIRS      => 10,
    CURLOPT_TIMEOUT        => 60,
]);

$response = curl_exec($ch);
if ($response === false) {
    http_response_code(502);
    header('Content-Type: application/json');
    echo json_encode(['error' => curl_error($ch)]);
    exit;
}

// split headers and body
$headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$status     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$body       = substr($response, $headerSize);
curl_close($ch);

// return status + body
http_response_code($status);
header('Content-Type: application/json');
echo $body;
