<?php
// This file acts as middleware: it receives the AJAX, calls the external service, and returns JSON.
// The client-side should make a call like this example:
// https://partners.oddsscanner.com/index.php?module=OddsscannerSkinLoader/middleware/index

$SERVICE_URL = 'https://development-partners-reports.infra.oddsscanner.org';


// $app_user is populated by Rukovoditel sessikon (use this for access control)
global $app_user;

// Basic auth
if (!isset($app_user['id'])) {
  http_response_code(401);
  echo json_encode(['error' => 'Authentication required']);
  exit;
}

// get query path (ex: /reports/SummaryReport)
$endpoint = $_GET['endpoint'] ?? '';
if ($endpoint === '') {
    http_response_code(400);
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Missing endpoint path']);
    exit;
}

// build final URL
$target = rtrim($SERVICE_URL, '/') . $endpoint;


// POST body from the frontend
$rawBody = file_get_contents('php://input');

// prepare cURL
$ch = curl_init($target);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HEADER         => true,
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => $rawBody,
    CURLOPT_HTTPHEADER     => [
        'Content-Type: application/json',
        'Accept: application/json'
    ],
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_MAXREDIRS      => 10,
    CURLOPT_TIMEOUT        => 60,
]);

$response = curl_exec($ch);
if ($response === false) {
    http_response_code(502);
    header('Content-Type: application/json');
    echo json_encode(['error' => curl_error($ch)]);
    exit;
}

// split headers and body
$headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$status     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$responseBody = substr($response, $headerSize);
curl_close($ch);

// return status + responseBody
http_response_code($status);
header('Content-Type: application/json');
echo $responseBody;
exit; // To prevent rendering rukovoditel view