// This global var stores part of the arguments for the buttons that open the widgets modal
// By adding the ids to the array, it will be possible to generate the selectors dynamically
var modalButtonsIds = ['path=50-1', 'path=50-2', 'path=50-3'];

// This global var stores ids of all inputs for colors so that we can control the values inserted
var colorPickerInputsId= ['fields_643', 'fields_680'];

// This simulates the light overlay created on figma for the secondary buttons
// and returns the final hexcolor
function blendColors(baseHex, overlayHex, overlayAlpha) {
    // Validate hex string
    const isValidHex = hex => /^#([0-9a-fA-F]{6})$/.test(hex);

    if (!isValidHex(baseHex)) {
        return false;
    }
    
    const hexToRgb = hex => ({
      r: parseInt(hex.slice(1, 3), 16),
      g: parseInt(hex.slice(3, 5), 16),
      b: parseInt(hex.slice(5, 7), 16)
    });
  
    const rgbToHex = ({r, g, b}) =>
      '#' +
      [r, g, b]
        .map(x => Math.round(x).toString(16).padStart(2, '0'))
        .join('');
  
    const base = hexToRgb(baseHex);
    const overlay = hexToRgb(overlayHex);
  
    const blended = {
      r: overlay.r * overlayAlpha + base.r * (1 - overlayAlpha),
      g: overlay.g * overlayAlpha + base.g * (1 - overlayAlpha),
      b: overlay.b * overlayAlpha + base.b * (1 - overlayAlpha)
    };
  
    return rgbToHex(blended);
}

function widgetsInit() {
    const CHECK_INTERVAL = 200; // milissegundos
    const MAX_ATTEMPTS = 5;
    let attempts = 0;
    
    if ($('.page-title').text().trim() == 'Widget') {
        const interval = setInterval(function () {
            if ($('body').hasClass('widgets-init-complete')) {
                clearInterval(interval);
                return;
            }

            if ($('.listing-types-switches').length && $('.listing-section-align-left').length) {
                $('.entity_items_listing').addClass('js-widgets-card');

                setTimeout(function () {
                        
                    // First page, create Access button by copying the original info button and create the preview button
                    $('.table-scrollable > table > tbody > tr').each(function(){
                        var editLink = $(this).find('a.item_heading_link').first().attr('href');
        
                        var buttonTd = $('<td class="js-access-button"><a href="'+ editLink +'" class="btn btn-primary">Access</a></td>');
                        
                        $(this).append(buttonTd);
                    

                        // Preview
                        var previewUrl = $(this).find($('td.listing-section-align-left:nth-child(3) tbody td')).text();
                        
                        if (previewUrl){

                            var previewButton = $('<button class="js-preview-button">Preview</button>').on('click', function () {
                                $.fancybox({
                                    type: 'iframe',
                                    href: previewUrl,
                                    width: '90%',         
                                    height: '90%',
                                    maxWidth: 1200,       
                                    maxHeight: 800,
                                    autoSize: false,      
                                    fitToView: false,     
                                    closeClick: false,
                                    openEffect: 'none',
                                    closeEffect: 'none'
                                });
                            });

                            $(this).find($('.fieldtype-image-container')).append(previewButton);
                        }
                    }); 


                    // Set as finished
                    $('body').addClass('widgets-init-complete');
                    clearInterval(interval);
                }, 100); 
            }

            attempts++;
            if (attempts >= MAX_ATTEMPTS) {
                clearInterval(interval);
                console.warn('widgetsInit: Max attempts reached.');
            }
        }, CHECK_INTERVAL);
    }
}

function reloadPreviewIframe(iframeUrl, settingsObj){
    if ($('#modal-preview').length){
        var settings = objectToQueryString(settingsObj);
        
        $('#modal-preview').attr('src', iframeUrl+settings);
    }
}

function collectFormData(formElement) {
    let formData = {};

    formElement.find('.form-group').each(function(){
        var $field = $(this).find('input, textarea, color, select');
        var name = $(this).find('label').first().text(); 
        var value = $field.val();
        
        // Remove the asterisk and spaces from the name
        name = name.replace(/[\s*]+/g, '').trim().toLowerCase();

        if (value){
            formData[name] = value;
        }

        // Remove problematic query strings from the object
        delete formData['product'];
    });

    return formData;
}

function validateHexColor(fields) {
    fields.forEach(function(field) {
        let $input = $('#' + field);

        $input.on('input', function () {
            let newVal = $(this).val().replace(/[^a-fA-F0-9]/g, '').substring(0, 6);
            $(this).val(newVal.length > 0 ? '#' + newVal : '');
        });

        let initialVal = $input.val();
        if (initialVal) {
            let cleaned = initialVal.replace(/[^a-fA-F0-9]/g, '').substring(0, 6);
            $input.val(cleaned.length > 0 ? '#' + cleaned : '');
        }
    });
}


function addPreviewToModal(formEl){
    // setTimeout( function(){
        var settings = collectFormData(formEl);
        
        // Preview HTML structure to be injected
        var previewMarkup = '<div class="js-preview-styling col-md-9 col-md-offset-3"> \
                                <span class="title">Color usage preview</span> \
                                <div class="preview-styling-wrapper"> \
                                    <div class="preview-styling-inner-wrapper"> \
                                        <div class="top"> \
                                            <div class="primary-buttons"> \
                                                <button id="preview-btn-primary" type="button">Active button</button> \
                                                <span>Inactive button </span> \
                                            </div> \
                                        </div> \
                                        <div class="bottom"> \
                                            <button id="preview-btn-secondary" type="button">Active tab</button> \
                                            <span>Inactive tab</span> \
                                        </div> \
                                    </div> \
                                </div> \
                            </div>';
        $('#ajax-modal .form-body').append(previewMarkup);

        // Update preview with the settings on the form
        $('#ajax-modal .modal-body #preview-btn-primary').css({
            'background-color': settings.primarycolor,
            'color': settings.secondarycolor
        });
        $('#ajax-modal .modal-body #preview-btn-secondary').css({
            'background-color': blendColors(settings.primarycolor, '#ffffff', 0.95),
            'color': settings.primarycolor
        });
        
        // When the fields are updated, update the preview as well
        $('#ajax-modal form').on('change', 'input', function(){
            settings = collectFormData(formEl);
            
            $('#ajax-modal .modal-body #preview-btn-primary').css({
                'background-color': settings.primarycolor,
                'color': settings.secondarycolor
            });
            $('#ajax-modal .modal-body #preview-btn-secondary').css({
                'background-color': blendColors(settings.primarycolor, '#ffffff', 0.95),
                'color': settings.primarycolor
            });
        });
    // }, 600);
}


$(function() {
    widgetsInit();

    // Detect if we are on the final page of the widget,
    // to show the snippet on the main box on the left
    setTimeout(function () {
        if ($('.panel-body.item-details').length && $('.form-group.form-group-692').length){
            $('.form-group.form-group-692').hide();
            $('.btn-default[title="Info"]').hide();

            var snippetId = 'widget-code';
            var snippet = $('.form-group.form-group-692 td span').html();
            const $btn = $('<button>')
                .text('Copy')
                .addClass('js-copy-clipboard')
                .attr('data-target', snippetId);

            var codeSnippetContainer = $('<div class="js-code-snippet-container"></div>');

            var titleDescription = $('<div class="description"><strong>Code Snippet</strong>Copy the code below and integrate it on your Website(s).</p></div>');
            var codeSnippetWrapper = $('<div class="js-code-snippet"></div>');
            var codeSnippet = $('<span id="' + snippetId + '"></span>');
            codeSnippet.append(snippet);
            codeSnippetWrapper.append(codeSnippet).append($btn);
            codeSnippetContainer.append(titleDescription).append(codeSnippetWrapper);
            
            $('.portlet-item-description .prolet-body-actions').prepend(codeSnippetContainer);
        }

        
    }, 1000);


    // Modal widget
    // Wait for the table with actions to be ready
    // I don't like this either, but it is the only way to ensure that the buttons are ready
    setTimeout(function () {

        // Generate selectors from the global variable modalButtonsIds
        var selector = modalButtonsIds.map(function(id) {
            return `a[onclick*="${id}"], button[onclick*="${id}"]`;
        }).join(', ');
        var widgetModalBtns = $(selector);
    
        widgetModalBtns.on('click', function () {
            // Wait for the modal to be ready
            setTimeout(function () {
                // Check if any color picker inputs are present in the DOM
                var hasInputs = colorPickerInputsId.some(function(id) {
                    return document.getElementById(id) !== null;
                });
    
                if (hasInputs) {
                    validateHexColor(colorPickerInputsId);
                    addPreviewToModal($('#ajax-modal form'));
                }
            }, 1000);
        });
    
        
    }, 1000);

});