/**
 * This file requires the OddsScannerSkinLoader Plugin to function properly.
 * Ensure that the plugin is enable on server.php. 
 */

function addCopyToScript(){
    $("td").each(function(index) {
        let text = $(this).text();
        
        // Wrap the content in a span only if a <script> tag is found,
        // then append the button element.
        
        // Regular expression to detect <script> tags
        let scriptRegex = /<script\b[^>]*>(.*?)<\/script>/gi;
  
        if (scriptRegex.test(text)) {
            // $(this).empty();

            const linkId = 'aff-link-' + index;
            const $btn = $('<button>')
                .text('Copy')
                .addClass('js-copy-clipboard')
                .attr('data-target', linkId);

            const $span = $('<span>')
                .text(text)
                .attr('id', linkId)
                .addClass('js-link-wrapper');

            const $wrapperDiv = $('<div>')
                .addClass('js-highlighted-snippet') // Optional class for styling
                .append($span)
                .append($btn);

            // Clear the current content and add the new span
            $(this).empty().append($wrapperDiv);
        }
    });
}

// Affiliate links
// Detect if has link and add a button to copy to clipboard
// timeout needed because the table is loaded after page load
function addCopyToLink(){
    setTimeout(function() {
        $('.' + AffiliateLinkCssClass).each(function(index) {
            const text = $(this).text().trim();
        
            // Check if it starts with http or https
            if (text.startsWith('http://') || text.startsWith('https://')) {
                const linkId = 'aff-link-' + index;
                const $btn = $('<button>')
                    .text('Copy')
                    .addClass('js-copy-clipboard')
                    .attr('data-target', linkId);

                const $span = $('<span>')
                    .text(text)
                    .attr('id', linkId)
                    .addClass('js-link-wrapper');

                const $wrapperDiv = $('<div>')
                    .addClass('js-affiliate-wrapper') // Optional class for styling
                    .append($span)
                    .append($btn);

                // Clear the current content and add the new span
                $(this).empty().append($wrapperDiv);
            }
        });
    }, 700);
}

// Settings
var AffiliateLinkCssClass = 'field-317-td';

/**
 * Converts an object of key-value pairs into a URL query string.
 * The first parameter starts with '?', and subsequent ones start with '&'.
 *
 * @param {Object} params - An object containing key-value pairs to convert.
 * @returns {string} A properly formatted query string.
 */
function objectToQueryString(params) {
    if (typeof params !== 'object' || params === null) {
        return '';
    }

    const keys = Object.keys(params);
    if (keys.length === 0) return '';

    let queryString = '?';

    keys.forEach((key, index) => {
        const value = encodeURIComponent(params[key]);
        const prefix = index === 0 ? '' : '&';
        queryString += `${prefix}${encodeURIComponent(key)}=${value}`;
    });

    return queryString;
}

function lockBodyScroll() {
    if ($(window).width() < 1023) {
        const $sidebar = $('.page-sidebar');

        function updateBodyScroll() {
            const expanded = $sidebar.attr('aria-expanded') === "true";
            if (expanded) {
                $('body').css('overflow', 'hidden'); 
                $('.header').css('position', 'fixed'); 
            } else {
                $('body').css('overflow', ''); 
                $('.header').css('position', 'static'); 
                $(window).scrollTop(0); 
            }
        }

        updateBodyScroll();

        const observer = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                if (mutation.attributeName === 'aria-expanded') {
                    updateBodyScroll();
                }
            });
        });

        observer.observe($sidebar[0], {
            attributes: true
        });
    }
}

function updateMenu(){
    if ($('.menu-reportsreports').length) {

        $('.menu-reportsreports + .sub-menu span.title').each(function() {
            if ($(this).text() == 'Reports'){
                var reportsText = $(this).text();
                var reportsUrl = $(this).parent().attr('href');

                // Remove original reports menu
                $('.menu-reportsreports').parent('li').remove();

                // Menuitem markup
                var $menuitem = `<li>
                                    <a class="js-custom-link" href="${reportsUrl}">
                                        <i class="fa fa-bar-chart" aria-hidden="true"></i>
                                        <span class="title level-0">${reportsText}</span>
                                    </a>
                                </li>`;

                // Append the new menu item to the sidebar menu
                $('ul.page-sidebar-menu').append($menuitem);

            }
        });
    }
}

$(function() {
    addCopyToScript();
    addCopyToLink();
    lockBodyScroll();
    updateMenu();
    
    // Override ajax call on table pagination
    if (typeof load_items_listing === 'function') {
        var original_load_items_listing = load_items_listing;

        load_items_listing = function(container, page) {
            // run original function
            original_load_items_listing(container, page); 
            
            // Delay to wait for AJAX to fully render new content
            setTimeout(function () {
                addCopyToLink();
 
                if ($('.js-table-as-card').length){
                    bannersInit();
                }
            }, 500);
        };
    }

    // Copy to clipboard functionality
    $(document).on("click", ".js-copy-clipboard", function() {
        let targetId = $(this).attr("data-target");
        let textToCopy = $("#" + targetId).text();
        let $this = $(this);
        let tempInput = $("<textarea>");

        $("body").append(tempInput);
        tempInput.val(textToCopy).select();
        document.execCommand("copy");
        tempInput.remove();
        
        console.info("Copied to clipboard!");

        $this.text("Copied");

        setTimeout(function() {
            $this.text("Copy");
        }, 1000);
    }); 
});