function generateAnchorLinksFromHeadings($contentArea, $targetContainer) {
    $contentArea.find('h1, h2, h3, h4, h5, h6').each(function (index) {
        const $heading = $(this);
        let title = $heading.text().trim();
        let tagName = $heading.prop("tagName").toLowerCase();

        // Create ID
        let id = title
            .toLowerCase()
            .replace(/[^a-z0-9\s-]/g, '') // remove special characters
            .replace(/\s+/g, '-')         // replace spaces with hyphens
            .replace(/-+/g, '-');         // remove duplicate hyphens

        // By adding the index to the ID, we ensure uniqueness when headings have the same text
        id = id + '-' +index;

        $heading.attr('id', id);

        // Add a class or data attribute for styling
        $targetContainer.append(
            `<li class="toc-item ${tagName}"><a href="#${id}" data-heading="${tagName}">${title}</a></li>`
        );
    });
}

function updateActiveToCLink() {
    const offset = 200;
    const buffer = 100;
    const scrollTop = $(window).scrollTop();
    const scrollTrigger = scrollTop + offset + buffer;

    if (scrollTop < 50) {
        $('.table-contents a').parent('li').removeClass('active');
        $('.table-contents ul li:first-child').addClass('active');
        moveIndicatorToActive();
        return; 
    }

    let currentId = null;

    $(":header").each(function() {
        if (scrollTrigger >= $(this).offset().top) {
            currentId = $(this).attr('id');
        }
    });

    if ($(window).scrollTop() + $(window).height() + 200 >= $(document).height()) {
        const $lastHeader = $(":header").last();
        currentId = $lastHeader.attr('id');
    }

    if (currentId) {
        $('.table-contents a').parent('li').removeClass('active');
        $('.table-contents a[href="#' + currentId + '"]').parent('li').addClass('active');
        moveIndicatorToActive();
    }
}

function moveIndicatorToActive() {
    const $activeItem = $('.table-contents li.active');
    const $indicator = $('.toc-indicator');

    if ($(window).width() < 1023) {
        // In mobile we will update the dropdown menu
        $('.js-mobile-menu').text($activeItem.text());
    } else {
        // In desktop we will update the indicator
        if ($activeItem.length) {
            const offsetTop = $activeItem.position().top;
            $indicator.css('top', offsetTop + 'px');
        }
    }
}

// Detect images to add zoom effect
function detectImageLinks() {
    $('.js-richtext-container img').each(function() {
        var imageUrl = $(this).attr('src');

        $(this).on('click', function() {
            $.fancybox.open(imageUrl);
        });
    });
}

function tableContentInit() {
    // Set first table of content link to active
    $('.table-contents ul li:first-child').addClass('active');
        
    // Mobile version
    if ($(window).width() < 1023) {
        $('.table-contents').clone().addClass('js-mobile').prependTo('.page-content-wrapper:nth-child(1)');
        $('.table-contents:not(.js-mobile)').remove();

        $('.table-contents .js-mobile-menu').click(function() {
            $(this).toggleClass('is-open');
            $('.table-contents ul').slideToggle();
            $('body').toggleClass('lock-scroll');   
        });
    }

    $('.table-contents a').on('click', function (e) {
        e.preventDefault();
        var offset = $(window).width() < 1023 ? 80 : 20;
        isScrollHandlingEnabled = false; // Disable scroll detection
    
        $('.table-contents li').removeClass('active');
        $(this).parent('li').addClass('active');
    
        const targetId = $(this).attr('href');
    
        if ($(window).width() < 1023) {
            // Scroll to the target after closing the menu
            $('.table-contents ul').slideUp(300, function () {
                $('body').removeClass('lock-scroll');   
                $('html, body').animate({
                    scrollTop: $(targetId).offset().top - offset
                }, 500, function () {
                    isScrollHandlingEnabled = true;
                });
            });
    
        } else {
            // Scroll to the target
            $('html, body').animate({
                scrollTop: $(targetId).offset().top - offset
            }, 500, function () {
                isScrollHandlingEnabled = true;
            });
        }
    });

    moveIndicatorToActive();
}


$(function() {
    if ($('.ipage-description').length) {
        let isScrollHandlingEnabled = true;

        $('.ipage-description').each(function () {
            const $description = $(this);
            
            $(this).parent('.col-md-12').addClass('js-richtext-container');

            // Clone the description to move it safely
            const $descriptionClone = $description.clone();
        
            // Create new structure
            const $row = $('<div class="row js-row-same-height"></div>');
            const $col8 = $('<div class="col-md-9"></div>');
            const $col4 = $('<div class="col-md-3"></div>');
            const $tocMarkup = $('<div class="table-contents"><span class="js-mobile-menu"></span><ul></ul><div class="toc-indicator"></div></div>');
        
            // Add the cloned description
            $col8.append($descriptionClone);
            $row.append($col8, $col4);
            $col4.append($tocMarkup);
        
            // Insert the new structure after the original description's container
            $description.after($row);
        
            // Remove the original
            $description.remove();

            // Generate anchor links
            generateAnchorLinksFromHeadings($descriptionClone, $col4.find('.table-contents ul'));

            // Scroll tracking
            $(window).on('scroll', function () {
                if (isScrollHandlingEnabled)
                    updateActiveToCLink();
            });

            tableContentInit();

            detectImageLinks();
            
        });
    } 
    
});
