function bannersInit() {
    const CHECK_INTERVAL = 500; // milissegundos
    const MAX_ATTEMPTS = 20;
    let attempts = 0;
    
    if ($('.page-title').text().trim() == 'Banner') {
        const interval = setInterval(function () {
            if ($('body').hasClass('banners-init-complete')) {
                clearInterval(interval);
                return;
            }

            if ($('.listing-types-switches').length && $('.listing-section-align-left').length) {
                $('.entity_items_listing').addClass('js-table-as-card');

                setTimeout(function () {
                    $('.js-table-as-card .listing-section-align-left td').each(function (index) {
                        const text = $(this).text().trim();
                        const innerHtml = $(this).html();

                        // Check <script> tag
                        const scriptRegex = /<script\b[^>]*>(.*?)<\/script>/gi;
                        if (scriptRegex.test(text)) {
                            const linkId = 'aff-link-' + index;
                            const $btn = $('<button>')
                                .text('Copy')
                                .addClass('js-copy-clipboard')
                                .attr('data-target', linkId);

                            const $span = $('<span>')
                                .text(text)
                                .attr('id', linkId)
                                .addClass('js-link-wrapper');

                            const $wrapperDiv = $('<div>')
                                .addClass('js-affiliate-wrapper')
                                .append($span)
                                .append($btn);

                            $(this).empty().append($wrapperDiv);
                        }

                        // Check links for images
                        const imageLinkRegex = /<a[^>]+href=["'](https?:\/\/[^"']+\.(?:jpeg|jpg|webp|gif|svg|png))["'][^>]*>(.*?)<\/a>/gi;
                        if (imageLinkRegex.test(innerHtml)) {
                            const imageUrl = text;
                            const $img = $('<img>').attr('src', imageUrl).css({ maxWidth: '100%', height: 'auto' });

                            const $previewBtn = $('<button>')
                                .text('Preview')
                                .addClass('js-preview-image')
                                .on('click', function () {
                                    $.fancybox.open(imageUrl);
                                });

                            const $wrapperDiv = $('<div>')
                                .addClass('js-image-wrapper')
                                .append($img)
                                .append($previewBtn);

                            $(this).empty().append($wrapperDiv);
                        }
                    });

                    // Add edit button
                    $('td.listing-section-align-left:nth-child(3) .listing-section-table tr:nth-child(3) td').each(function () {
                        const editDialog = $(this).parents('.table').find('a[title="Edit"]').attr('onclick');

                        if (editDialog) {
                            const $editBtn = $('<button>')
                                .text('Edit')
                                .attr('onclick', editDialog)
                                .addClass('js-edit-link');

                            $(this).append($editBtn);
                        }
                    });

                    // set as finished
                    $('body').addClass('banners-init-complete');
                    clearInterval(interval);
                }, 300); 
            }

            attempts++;
            if (attempts >= MAX_ATTEMPTS) {
                clearInterval(interval);
                console.warn('bannersInit: Max attempts reached.');
            }
        }, CHECK_INTERVAL);
    }
}

$(function() {
    bannersInit();
});